<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Booking extends Model 
{

    protected $table = 'bookings';
    public $timestamps = true;
    protected $fillable = array('user_tutor_id', 'user_student_id', 'subject_id', 'address', 'start_date', 'end_date', 'lat', 'description', 'status_id');

    public function userStudent()
    {
        return $this->hasOne('UserStudent', 'user_student_id');
    }

    public function userTutor()
    {
        return $this->hasOne('UserTutor', 'user_tutor_id');
    }

    public function subject_id()
    {
        return $this->hasOne('BookingSubject');
    }

    public function files()
    {
        return $this->belongsToMany('BookingFiles', 'booking_id');
    }

    public function status()
    {
        return $this->hasOne('BookingStatus', 'status_id');
    }

}